#ifndef LLF_ECPKI_ECDH_DB_DEF_H
#define LLF_ECPKI_ECDH_DB_DEF_H
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  28/05/2006
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A abow stated brief description of this module
   *
   *  \version LLF_ECPKI_ECDH_db_def.h#1:incl:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/*
 * This file is included in the middle of the struct declaration for CRYS_ECPKI data types
 * It contains the platform-specific parts of the context struct. As such:
 *
 *  1) file should not use any includes it is a part of the CRYS_ECPKI_Types.h file !!!!
 *  2) only the CRYS_ECPKI_Types.h file should include this file. 
 */

 /*!  The ECDH temporary data 
	Size = 39*CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 2 =
	= 3*CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 1 + 
	( sizeof(LLF_ECPKI_key_gen_db_def.h) = 36*CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 1 )  */

      struct
      {
          /*! The aligned temporary buffers for two projective points */
		  DxUint32_t               s[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS + 1];
		  CRYS_ECPKI_PointAffine_t Point1;

      	  /* Temporary buffers used for the EC scalar multiplication  */
	      DxUint32_t TempBuff[CRYS_ECPKI_MODUL_MAX_LENGTH_IN_WORDS * 36];
      }LLF;
   
#endif /*LLF_ECPKI_ECDH_DB_DEF_H*/



